/****************************************************************************
* Donohue and Wolfers (2006) 
* Figure 10
* Reporting Bias in Estimated Effects of Executions on Homicide: 
* Reported Estimates within Each Study
****************************************************************************/


clear

set more off 
cd "..."
use "Estimates.dta", clear

set seed 1
reg beta se if national==0 & study~="Zb"
reg beta se if main==1 & national==0 & study~="Zb"
bys study: reg beta se if national==0 & study~="Zb"

correl beta se if national==0 & study~="Zb"
correl beta se if main==1 & national==0 & study~="Zb"
bys study: correl beta se if national==0 & study~="Zb"

gen effect=beta if main==1
tomode effect, by(study) replace
gen ci95upper=effect+1.96*se
gen ci95lower=effect-1.96*se

gen str20 studyname=""
for X in any DRS DS KLS MG S Za \ Y in any "Dezbakhsh, Rubin & Shepherd" "Dezbakhsh & Shepherd" "Katz, Levitt & Shustorovich" "Mocan & Gittings" "Shepherd" "Zimmerman": replace studyname="Y" if study=="X"


#delimit;
twoway 
/*	(line t2 se, lcolor(black) lpattern(solid) sort) */
	(lfit beta se, lcolor(gray) lpattern(dash) sort)
	(scatter beta se if study=="DRS", msymbol(circle) mcolor(red))
	(scatter beta se if study=="DS" & national==0, jitter(2) msymbol(square) mcolor(blue))
	(scatter beta se if study=="KLS", jitter(1) msymbol(X) mcolor(chocolate))
	(scatter beta se if study=="MG", msymbol(triangle_hollow) mcolor(magenta))
	(scatter beta se if study=="S", jitter(2) msymbol(triangle) mcolor(green)) 
	(scatter beta se if study=="Za", jitter(1) msymbol(square_hollow) mcolor(black)) 
	if national==0 & study~="Zb"
,
	by(studyname,
	title(Reporting Bias: Estimated Effects of Executions on Homicide) 
	subtitle("H0: No reporting bias implies that estimated effects should be unrelated to the standard error" "H1: Results are more likely to be reported if the effect is at least twice the standard error (t>2)", size(small)) 
	note(
		"Coefficients converted into homicides reduced for the average executing state in 1996" 
		, size(small))
	xrescale
	yrescale
)
	legend(order(1 "Line of best fit"))
	ytitle("Coefficient estimate:" "Number of homicides reduced per execution", size(medsmall))
	xtitle("Standard error of estimated effect")
	ylabel(, angle(horizontal))
	xsize(10) ysize(7.5)
;
#delimit cr
